<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- CSS only -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-Zenh87qX5JnK2Jl0vWa8Ck2rdkQ2Bzep5IDxbcnCeuOxjzrPF/et3URy9Bv1WTRi" crossorigin="anonymous">

    <!-- JavaScript Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-OERcA2EqjJCMA+/3y+gxIOqMEjwtxJY7qPCqsdltbNJuaOe923+mo//f6V8Qbsw3" crossorigin="anonymous"></script>

    <link href="estilo.css" rel="stylesheet">

    <title>Vuelos</title>
</head>

<body>
    <form action="" method="POST" enctype="multipart/form-data">
        <div class="row col-md-12 justify-content-center" style="margin: auto;">
            <div class="row col-md-4 col-ms-12">
                <div class="mb-3">
                    <label for="formFile" class="form-label">Agregar el reporte CSV modificado</label>
                    <input class="form-control" type="file" accept=".csv" id="fileCertificado" name="fileCertificado" Required>
                </div>
                <div class="d-grid gab-2">
                    <input type="submit" name="btnGuardar" id="btnGuardar" class="btn btn-primary" value="Agregar">
                </div>
            </div>
        </div>
    </form>
    <br>
    <?php
    include './back.php';

    #region Listas de Horas - Aircraft

    $horaI = array(
        "05:00:00",
        "06:00:00",
        "07:00:00",
        "08:00:00",
        "09:00:00",
        "10:00:00",
        "11:00:00",
        "12:00:00",
        "13:00:00",
        "14:00:00",
        "15:00:00",
        "16:00:00",
        "17:00:00",
        "18:00:00",
        "19:00:00",
        "20:00:00",
        "21:00:00",
        "22:00:00",
    );

    $horaF = array(
        "05:59:59",
        "06:59:59",
        "07:59:59",
        "08:59:59",
        "09:59:59",
        "10:59:59",
        "11:59:59",
        "12:59:59",
        "13:59:59",
        "14:59:59",
        "15:59:59",
        "16:59:59",
        "17:59:59",
        "18:59:59",
        "19:59:59",
        "20:59:59",
        "21:59:59",
        "22:59:59",
    );

    $aircraftList = array(
        "Cessna Caravan",
        "Cessna Caravan (10)",
        "TI-BCX",
        "TI-BDL",
        "TI-BDW",
        "TI-BDX",
        "TI-BDY",
        "TI-BGA",
        "TI-BGB",
        "TI-BHL",
        "TI-BHM",
        "TI-BKS",
        "VIRTUAL2",
        "VIRTUAL3",
        "VIRTUAL4",
    );

    #endregion        

    #region Guardar CSV - Truncate Tabla - Insert datos CSV

    if (!empty($_REQUEST['btnGuardar'])) {
        $temp = explode(".", $_FILES["fileCertificado"]["name"]);
        $newfilename = "Reporte" . '.' . end($temp);
        move_uploaded_file($_FILES["fileCertificado"]["tmp_name"], "./Reportes/" . $newfilename);

        /* Leer y recorrer el fichero */
        $csv = file('./Reportes/Reporte.csv');

        $borrar = truncate(); // Limpiar tabla para nuevo registro CSV

        foreach ($csv as $linea) {
            $linea = str_getcsv($linea, ",");

            $consulta = "INSERT INTO vuelos (FLIGHT_NUMBER, AIRCRAFT, PAX, GENDER_PAX, STD, RTE, STA) 
                         VALUES ('$linea[0]', '$linea[1]', '$linea[2]', '$linea[3]', '$linea[4]', '$linea[5]', '$linea[6]')";
            $resultado = $conexion->prepare($consulta);
            $resultado->execute();
        }
    }

    #endregion

    ?>
    <table class="table table-responsive table-bordered">
        <thead>
            <tr>
                <th style="background-color: #fff;">AIRCRAFT</th>
                <?php

                #region Encabezados

                foreach ($horaI as $hora) {
                    echo "<th style='background-color: #fff;'>$hora</th>";
                }

                #endregion

                ?>
            </tr>
        </thead>
        <tbody>
            <?php

            #region Datos de los vuelos

            foreach ($aircraftList as $airL) {
                echo "<tr>";
                echo "<td class='aircraft'>$airL</td>";

                $i = 0;

                foreach ($horaI as $hora) {
                    echo "<td>";
                    $data = buscar($airL, $hora, $horaF[$i]);

                    if ($data == true) {
                        $info = generar($data);
                        echo $info;
                    }
                    echo "</td>";

                    $i = $i + 1;
                }
                echo "</tr>";
            }

            #endregion

            ?>
        </tbody>
    </table>
    <br><br>
    <br><br><br>
</body>
<script>
    const popoverTriggerList = document.querySelectorAll('[data-bs-toggle="popover"]')
    const popoverList = [...popoverTriggerList].map(popoverTriggerEl => new bootstrap.Popover(popoverTriggerEl))
</script>

</html>